<!-- Actionable insights must recommend an action that needs to take place. An actionable insight both defines the insight and clearly calls out action or next step required to improve based on the result of the research observation or data. Actionable insights are tracked over time and will include follow-up. Please follow the tasks outlined in this issue for best results. Learn more in the handbook here: https://about.gitlab.com/handbook/product/ux/ux-research-training/research-insights/#actionable-insights 

This issue template is for an actionable insight that requires a change in the product.-->

### Insight
<!-- Describe the insight itself: often the problem, finding, or observation.-->

### Business Problem
<!-- Where the insight is focused on the user/customer, the business problem represents how the insight could positively impact the business. For example, an insight around a friction area during the trial experience could be inhibiting first orders. -->

### Hypothesis
<!-- Detail how actioning the insight may impact the business problem identified. -->

### Supporting evidence
<!-- Describe why the problem is happening, or more details behind the finding or observation. Try to include quotes or specific data collected. Feel free to link the Actionable insight from Dovetail here if applicable instead of retyping details. -->

### Action
<!--Since this is an actionable insight that requires a change in the product, ensure the action is algned to that. Describe the next step or action that needs to take place as a result of the research. The action should be clearly defined, achievable, and directly tied back to the insight. Make sure to use directive terminology, such as: change, update, add/remove, etc. -->

### Resources
 <!--Add resources as links below. May include a Dovetail project, Tableau dashboard, or more, as applicable. -->

- ...
- ...

### Tasks
 <!--Fill out these tasks in order to consider an Actionable Insight complete. Actionable Insights are created as confidential by default, but can be made non-confidential if the insight does not include information about competitors from a Competitor Evaluation or any other confidential information. -->

- [ ] Add relevant research, user journey, and follow-up issues as related issues.
- [ ] Assign this issue to the appropriate Product Manager, Product Designer, or UX Researcher.
- [ ] Add the appropriate `Group` (such as `~"group::source code"`) label to the issue.  This helps identify and track actionable insights at the group level.
- [ ] If the insight was generated from a user journey opportunity, add the ~"user journey" label.
- [ ] Adjust confidentiality of this issue if applicable

/label ~"Actionable Insight::Product change"
/confidential
